---
description: "A brief summary of what users learn in this tutorial, fit for search results and tooltips."
applies_to:
  stack:
  serverless:
type: tutorial
product:
---

<!-- Copy and paste this template to get started writing your tutorial, deleting the instructions and comments from your final page.

For complete guidance, refer to [the tutorial guide](https://www.elastic.co/docs/contribute-docs/content-types/tutorials).

-->

# [Descriptive title indicating what users learn]
<!-- REQUIRED

A clear, descriptive title that indicates what users learn or accomplish.

Examples:
- Build an ingest pipeline with processors
- Work with datetimes in ES|QL
- Tutorial: Threat hunting with ES|QL
-->

<!-- REQUIRED

Explain what the tutorial teaches, who it's for, and what users will be able to do by the end. Include:

- A brief description of what this tutorial teaches
- The intended audience and their expected skill level
- Learning objectives as a bulleted list
-->

Learn how to [brief description of the main task]. It assumes you have basic knowledge of:

- [Prerequisite concept 1]
- [Prerequisite concept 2]

By the end of this tutorial, you can:

- [Learning objective 1 — clear, achievable, and relevant to real-world tasks]
- [Learning objective 2]
- [Learning objective 3]

## Before you begin
<!-- REQUIRED

List all prerequisites including:
- Required prior knowledge or skills
- Software, hardware, or access requirements
- Data sets or environments to set up
- Estimated time to complete (optional but helpful)
-->

To <perform action in title>, you need the following:

- [Software or access requirement 1]
- [Software or access requirement 2]
- [Data or configuration requirement]

<!-- OPTIONAL: Estimated time -->
Estimated time: [X minutes/hours]

## Step 0: [Setup or data preparation]
<!-- OPTIONAL BUT COMMON

If the tutorial requires setup, sample data, or initial configuration, include it as Step 0. This keeps the tutorial self-contained.
-->

[Instructions for setting up the environment or adding sample data]

```language
[Setup code or commands] <1>
```

1. [Code annotation explaining what this does]

## Step 1: [First instructional task]
<!-- REQUIRED

Organize the tutorial into logical sections, each with a descriptive heading. Use numbered steps that begin with imperative verbs.

TIP: Use ### subsections to break complex steps into manageable pieces.
-->

[Brief introduction to what this step accomplishes and why it matters]

### [Subsection for complex steps - optional]

[Explanatory context about why this approach is recommended]

```language
[Code example] <1> <2>
```

1. [Code annotation explaining important lines]
2. [Additional annotation for clarity]

<!-- REQUIRED: Include checkpoints after significant steps -->
**Result:** [Describe what users should see or what state their system should be in]

## Step 2: [Second instructional task]
<!-- Build on previous steps with progressive complexity -->

[Introduction to this step, building on what was learned in Step 1]

```language
[Code example showing the next concept] <1>
```

1. [Code annotation]

**Result:** [Expected output or system state]

## Step 3: [Additional steps as needed]

[Continue building complexity progressively]

## Summary
<!-- OPTIONAL

Only include if it adds value beyond repeating the overview. Recap what users learned and accomplished.
-->

In this tutorial, you learned how to:

- [Summary of learning objective 1]
- [Summary of learning objective 2]
- [Summary of learning objective 3]

## Next steps
<!-- REQUIRED

Suggest follow-up tutorials, related features to explore, or ways to expand on what they built.
-->

- [Link to follow-up tutorial or next logical step]
- [Link to related feature to explore]
- [Suggestion for expanding on what was built]

## Related pages
<!-- REQUIRED

Links to related documentation such as conceptual topics, reference material, how-to guides, or troubleshooting resources.
-->

- [Link to conceptual overview]
- [Link to reference material]
- [Link to related how-to guide]

<!--
Learn more about:
- Required elements: https://www.elastic.co/docs/contribute-docs/content-types/tutorials#required-elements
- Optional elements: https://www.elastic.co/docs/contribute-docs/content-types/tutorials#optional-elements
- Best practices: https://www.elastic.co/docs/contribute-docs/content-types/tutorials#best-practices
-->
