---
description: "A concise summary highlighting what the feature or concept is and why it matters, fit for search results and tooltips."
applies_to:
  stack:
  serverless:
type: overview
product:
---

<!-- Copy and paste this template to get started writing your overview page, deleting the instructions and comments from your final page.

For complete guidance, refer to [the overview guide](https://www.elastic.co/docs/contribute-docs/content-types/overviews).

-->

# [Feature or concept name]
<!-- REQUIRED

A concise, descriptive name for the feature or concept.

Example: Inference processing
-->

<!-- REQUIRED

Introduction

Explain what this feature or concept is and why it matters to users. Your introduction should:

- Answer "What is it?" at a high level
- Establish the scope — what this overview covers
- Optionally clarify what's out of scope if that helps set expectations
- Help readers quickly determine if they're in the right place

Use the inverted pyramid: lead with the most important information, then add detail. -->

## Use cases
<!-- RECOMMENDED

Describe concrete scenarios or examples showing how the feature or concept applies in practice. Help users understand when and why they would use this.

Example structure:
### [Use case name]
[Brief description of the use case and its value]
-->

## How it works
<!-- RECOMMENDED

Explain the underlying mechanism, workflow, or architecture. Consider including a diagram to illustrate the concept.

Example:
The diagram below shows how [feature] processes [data/requests]:

[Mermaid diagram or image]

- [Key point about the workflow]
- [Another key point]
-->

## Key concepts
<!-- OPTIONAL

Define important terms or explain core concepts that are central to understanding this feature. Use this section when terminology might be unfamiliar to users.

- **[Term 1]:** [Definition]
- **[Term 2]:** [Definition]
-->

## Background
<!-- OPTIONAL

Provide context that helps readers understand the concept more deeply. This might include:

- Historical context (where the idea originated, why it works the way it does)
- Industry context (relevant standards, common patterns)
- Design decisions (why certain choices were made, what alternatives exist)

Only include this section when context adds meaningful value to understanding. -->

## [Comparison or decision section]
<!-- OPTIONAL

When helping users choose between options, use this section to compare features, trade-offs, or use cases. Consider using a table for clarity.

| Option | Best for | Trade-offs |
|--------|----------|------------|
| [Option A] | [Use case] | [Trade-off] |
| [Option B] | [Use case] | [Trade-off] |
-->

## Next steps
<!-- RECOMMENDED

Suggestions for what users can do after reading this overview -->

- [Link to getting started guide or tutorial]
- [Link to a how-to guide for a common task]

## Related pages
<!-- RECOMMENDED

Links to related documentation such as how-to guides, reference material, or other overviews -->

- [Link to how-to guide]
- [Link to reference material]
- [Link to related overview]

<!--
Learn more about:
- Required elements: https://www.elastic.co/docs/contribute-docs/content-types/overviews#required-elements
- Recommended elements: https://www.elastic.co/docs/contribute-docs/content-types/overviews#recommended-elements
- Optional elements: https://www.elastic.co/docs/contribute-docs/content-types/overviews#optional-elements
-->

