﻿---
title: API docs workflows by product
description: Each product team has a specific process for producing OpenAPI files in their repositories. This page provides a quick reference to help you navigate...
url: https://www.elastic.co/docs/contribute-docs/api-docs/workflows
---

# API docs workflows by product
Each product team has a specific process for producing OpenAPI files in their repositories. This page provides a quick reference to help you navigate to the right resources.

| Product                  | Repo                                                                                                      | OpenAPI spec file                                                                                                                                              | Live docs                                                                                |
|--------------------------|-----------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|
| Elasticsearch            | [elastic/elasticsearch-specification](https://github.com/elastic/elasticsearch-specification)             | [elasticsearch-openapi.json](https://github.com/elastic/elasticsearch-specification/blob/main/output/openapi/elasticsearch-openapi.json)                       | [elasticsearch](https://www.elastic.co/docs/api/doc/elasticsearch)                       |
| Elasticsearch Serverless | [elastic/elasticsearch-specification](https://github.com/elastic/elasticsearch-specification)             | [elasticsearch-serverless-openapi.json](https://github.com/elastic/elasticsearch-specification/blob/main/output/openapi/elasticsearch-serverless-openapi.json) | [elasticsearch-serverless](https://www.elastic.co/docs/api/doc/elasticsearch-serverless) |
| Kibana                   | [elastic/kibana](https://github.com/elastic/kibana/tree/main/oas_docs#kibana-api-reference-documentation) | [kibana.yaml](https://github.com/elastic/kibana/blob/main/oas_docs/output/kibana.yaml)                                                                         | [kibana](https://www.elastic.co/docs/api/doc/kibana)                                     |
| Kibana Serverless        | [elastic/kibana](https://github.com/elastic/kibana/tree/main/oas_docs#kibana-api-reference-documentation) | [kibana.serverless.yaml](https://github.com/elastic/kibana/blob/main/oas_docs/output/kibana.serverless.yaml)                                                   | [serverless](https://www.elastic.co/docs/api/doc/serverless)                             |
| Logstash                 | [elastic/logstash](https://github.com/elastic/logstash)                                                   | [logstash-api.yaml](https://github.com/elastic/logstash/blob/main/docs/static/spec/openapi/logstash-api.yaml)                                                  | [logstash](https://www.elastic.co/docs/api/doc/logstash)                                 |