﻿---
title: API docs checklist
description: Use this checklist to verify the quality, completeness, and consistency of your API docs contributions. Include required OpenAPI document info, Include...
url: https://www.elastic.co/docs/contribute-docs/api-docs/checklist
---

# API docs checklist
Use this checklist to verify the quality, completeness, and consistency of your API docs contributions.

## Structure, organization, and metadata

- Include required [OpenAPI document info](/docs/contribute-docs/api-docs/organize-annotate#add-open-api-document-info)
- Include [OpenAPI specification version](/docs/contribute-docs/api-docs/organize-annotate#add-openapi-specification-version)
- Define unique [operation identifiers](/docs/contribute-docs/api-docs/organize-annotate#add-operation-identifiers) using camelCase
- Use consistent [tags](/docs/contribute-docs/api-docs/organize-annotate#group-apis-with-tags) to group related operations
- Document [API lifecycle status](/docs/contribute-docs/api-docs/organize-annotate#specify-api-lifecycle-status) (availability, stability, version information)
- Mark deprecated APIs and properties with appropriate notices
- Document [required permissions](/docs/contribute-docs/api-docs/organize-annotate#document-required-permissions) for each operation


## Content quality and completeness

- Write clear [summaries](/docs/contribute-docs/api-docs/guidelines#write-summaries) (between 5-45 characters)
- Write detailed [descriptions](/docs/contribute-docs/api-docs/guidelines#write-descriptions) for operations, parameters, properties, tags etc.
- Document all [parameters](/docs/contribute-docs/api-docs/guidelines#document-parameters) and explain how changing defaults affects behavior
- Provide descriptions for non-obvious [enum values](/docs/contribute-docs/api-docs/guidelines#document-enum-values)
- Specify [default values](/docs/contribute-docs/api-docs/guidelines#set-default-values) for optional parameters
- Include realistic [examples](/docs/contribute-docs/api-docs/guidelines#add-examples) with helpful descriptions
- Add [links](/docs/contribute-docs/api-docs/guidelines#add-links) to related operations and documentation


## Quality assurance

- Preview your changes locally before submitting (see [Quickstarts](https://www.elastic.co/docs/contribute-docs/api-docs/quickstart))
- [Lint your API docs](/docs/contribute-docs/api-docs/guidelines#lint-your-api-docs) to identify and fix issues
- Check all links to ensure they work correctly
- Ensure examples are realistic and error-free