﻿---
title: Contribute to Elastic API docs
description: Learn how to contribute to Elastic's Open API docs across our various product repositories. While each team uses different toolchains and workflows, the...
url: https://www.elastic.co/docs/contribute-docs/api-docs
---

# Contribute to Elastic API docs
Learn how to contribute to Elastic's Open API docs across our various product repositories. While each team uses different toolchains and workflows, the core principles of how to write excellent API docs are the same.
1. [**How Elastic API docs work**](https://www.elastic.co/docs/contribute-docs/api-docs/overview) - Understand how API docs work at Elastic today, from source files to OpenAPI documents and published documentation.
2. [**Checklist**](https://www.elastic.co/docs/contribute-docs/api-docs/checklist) - Use the checklist to make sure your API docs aren't missing anything important.
3. [**Core guidelines**](https://www.elastic.co/docs/contribute-docs/api-docs/guidelines) - Learn universal principles for writing clear, informative, and valid API docs, including how to write summaries and descriptions, and how to add links and examples.
4. [**Organize and annotate**](https://www.elastic.co/docs/contribute-docs/api-docs/organize-annotate) - Learn how to group your APIs using tags and how to signal lifecycle status, deployment-type availability, and required permissions.
5. [**Quickstarts: Elasticsearch and Kibana**](https://www.elastic.co/docs/contribute-docs/api-docs/quickstart) - Follow step-by-step guides to contribute to Elasticsearch and Kibana API docs, including environment setup, local development workflow, and preview generation.
6. [**Find your workflow**](https://www.elastic.co/docs/contribute-docs/api-docs/workflows) - Find the workflow for the specific Elastic API docs you're interested in and learn how the OpenAPI docs are generated, validated, and published.
7. [**Report issues and get help**](https://www.elastic.co/docs/contribute-docs/api-docs/help) - Find out where to ask questions, report issues, and get support from the Elastic community and documentation team across all our API docs workflows.