﻿---
title: Contribute to Elastic documentation
description: In April 2025, Elastic migrated to a new documentation system at elastic.co/docs, using Markdown and the docs-builder toolchain, which coincided with...
url: https://www.elastic.co/docs/contribute-docs
---

# Contribute to Elastic documentation
In April 2025, Elastic migrated to a new documentation system at [elastic.co/docs](https://www.elastic.co/docs), using Markdown and the [`docs-builder`](https://elastic.github.io/docs-builder/) toolchain, which coincided with the release of Elastic Stack 9.0.0, Elastic Cloud Enterprise 4.0.0, and Elastic Cloud on Kubernetes 3.0.0.
This documentation site includes docs for:
- Elastic Stack 9.x
- Elastic Cloud Enterprise 4.x
- Elastic Cloud on Kubernetes 3.x
- Elastic Cloud Hosted
- Elastic Cloud Serverless

Refer to [Versioning and availability](https://www.elastic.co/docs/get-started/versioning-availability) to learn more.
This documentation is [**cumulative**](https://www.elastic.co/docs/contribute-docs/how-to/cumulative-docs): a new set of docs is not published for every minor release. Instead, each page stays valid over time and incorporates version-specific changes.
<tip>
  To learn more about the new docs UX, read [How to use the documentation](https://www.elastic.co/docs/get-started/howto-use-the-docs).
</tip>


## Contribute to `elastic.co/docs` (Markdown)


| System         | What it covers                               | Published to                                            | Format                                       | How to contribute                                                                                                                                                                                                                                              |
|----------------|----------------------------------------------|---------------------------------------------------------|----------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Main docs      | Guides, troubleshooting, release notes, etc. | [elastic.co/docs](https://www.elastic.co/docs)          | Markdown                                     | - [On the web](https://www.elastic.co/docs/contribute-docs/on-the-web) (quick edits)  - [Locally](https://www.elastic.co/docs/contribute-docs/locally) (complex changes)  - [Syntax guide](https://www.elastic.co/docs/contribute-docs/syntax-quick-reference) |
| API references | Elastic REST APIs                            | [elastic.co/docs/api](https://www.elastic.co/docs/api/) | [OpenAPI](https://swagger.io/specification/) | [Contribute to API docs](https://www.elastic.co/docs/contribute-docs/api-docs)                                                                                                                                                                                 |


## Report issues or request features


| Issue type     | Where to report                                                                                                                                                                                                                                                                                         |
|----------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Documentation  | - [Open a docs issue](https://github.com/elastic/docs-content/issues/new?template=internal-request.yaml) or [fix it yourself](https://www.elastic.co/docs/contribute-docs/locally)  - Elastic employees can use the [internal repo](https://github.com/elastic/docs-content-internal/issues/new/choose) |
| `docs-builder` | - [Bug report](https://github.com/elastic/docs-builder/issues/new?template=bug-report.yaml)  - [Discussion](https://github.com/elastic/docs-builder/discussions)                                                                                                                                        |


## Contribute to `elastic.co/guide` (Asciidoc)


| System                        | What it covers                                      | Published at                                                | Format/toolchain | How to contribute                                                                             |
|-------------------------------|-----------------------------------------------------|-------------------------------------------------------------|------------------|-----------------------------------------------------------------------------------------------|
| `elastic.co/guide` (Asciidoc) | Elastic docs and API references for 8.x and earlier | [elastic.co/guide](https://www.elastic.co/guide/index.html) | Asciidoc         | [Contribute to the Asciidoc docs](https://www.elastic.co/docs/contribute-docs/asciidoc-guide) |

<note>
  If you need to update documentation in both the Markdown and Asciidoc systems, you'll need two separate PRs. Refer to [Updating docs in both systems](/docs/contribute-docs/asciidoc-guide#updating-docs-in-both-systems).
</note>