﻿---
title: Multifactor authentication
description: Multifactor authentication (MFA) is mandatory when you log in to Elastic Cloud using a standard email/password combination, and can't be turned off. It...
url: https://www.elastic.co/docs/cloud-account/multifactor-authentication
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Multifactor authentication
Multifactor authentication (MFA) is **mandatory** when you log in to Elastic Cloud using a standard email/password combination, and can't be turned off. It helps protecting your account by adding an extra identity verification step when you log in. You can choose and define the MFA method to use based on your preference:
- Set up an **authenticator app** such as Google Authenticator, Microsoft Authenticator, or Okta Verify. These apps generate a time-based one-time password (TOTP) that you enter along with your password when you log in.
- Authenticate using a **hardware security key or biometric data**, such as a YubiKey or a fingerprint reader.
- Receive a verification code through **email**. You enter this code along with your password when you log in.

<note>
  You can no longer configure SMS as a multifactor authentication method.
</note>

<important>
  For enhanced security, we recommend you configure at least two different authentication methods. This redundancy ensures that losing access to one method doesn't impair access to your Elastic Cloud account.
</important>

If you use only a Google or Microsoft account to log in, then you can’t configure MFA in Elastic Cloud. You can check and manage your multifactor authentication options in your Google or Microsoft account security settings.

## Configure an authenticator app

To enable multifactor authentication using an authenticator app, you must enroll your device.
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Go to [User settings](https://cloud.elastic.co/user/settings) and choose **Profile**. Navigate to the **Multifactor authentication** section.
3. On the **Authenticator app** card, select **Set up**.
4. Scan the QR code with your authenticator app. If you can’t scan the QR code, then you can enter the code manually.
5. Enter the verification code generated by your authenticator app and select **Enable authentication method**.


## Configure a security key or biometrics

To enable multifactor authentication using a security key or biometrics, you must register your security key or biometric data.
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Go to [User settings](https://cloud.elastic.co/user/settings) and choose **Profile**. Navigate to the **Multifactor authentication** section.
3. On the **Security key or biometrics** card, select **Set up**.
4. Follow the prompts on your screen to register your hardware security key or your biometric authentication method.


## Configure email authentication

To enable multifactor authentication using an authenticator app, you must verify your email address.
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Go to [User settings](https://cloud.elastic.co/user/settings) and choose **Profile**. Navigate to the **Multifactor authentication** section.
3. On the **Email** card, select **Set up**.
4. Enter the verification code sent to your email address, and then select **Enable authentication method**.


## Remove a multifactor authentication method

You can remove a multifactor authentication method after it’s added by clicking **Remove**.
Before you remove an authentication method, you must set up an alternate method. If you can’t use any of your configured authentication methods — for example, if your device is lost or stolen — then [contact support](https://www.elastic.co/docs/troubleshoot).

## Frequently asked questions

Below are some frequently asked questions about the multifactor authentication changes added in September 2024.
**What changes are being introduced as part of the Elastic Cloud MFA initiative?**
The following changes were introduced to Elastic Cloud MFA starting September 9th, 2024:
- All users authenticating to any Elastic service through Elastic Cloud ([cloud.elastic.co/login](https://cloud.elastic.co/login)) with a username and password who have not yet set up an MFA method will be redirected to an MFA setup screen when they log in. Users will only be able to access their service after they successfully set up at least one MFA method, such as Authenticator or Email.
- SMS MFA is gradually being phased out. This aligns with our internal information security policy and the industry best practice to move away from SMS as an additional authentication factor due to it not being phishing-resistant. All users with SMS MFA will eventually be redirected to the MFA setup screen to set up a different MFA method.

We will be adding the following features in the future:
- Support for customer email notifications for suspicious logins, such as logins from a new device or subsequent logins from geographically distant locations.

Users who authenticate to Elastic Cloud using Google or Microsoft identities, or [SAML SSO](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/configure-saml-authentication), are not impacted by the MFA changes. In these cases, MFA is managed by the external identity provider.
**What are the Elastic services that can be accessed through Elastic Cloud?**
Elastic Cloud login ([cloud.elastic.co/login](https://cloud.elastic.co/login)) is used to authenticate the following services or portals provided by Elastic:
- Elastic Cloud - [cloud.elastic.co](https://cloud.elastic.co). In Elastic Cloud, MFA enforcement will apply to both Elastic Cloud trial and non-trial organizations.
- Support Hub - [support.elastic.co](https://support.elastic.co)
- Learning Portal - [learn.elastic.co](https://learn.elastic.co)
- *Coming soon:* Partner Portal - [partners.elastic.co](https://partners.elastic.co)

**Does MFA enforcement apply to all Elastic Cloud regions and organizations?**
Yes, the Elastic Cloud default MFA enforcement applies to all Elastic Cloud regions, including GovCloud, and all organizations, both trial and non-trial.
**Does MFA enforcement apply to direct login to Kibana or Elasticsearch?**
No, the Elastic Cloud default MFA enforcement does not apply when selecting **Log in with Elasticsearch** on the Kibana login screen or connecting to an Elasticsearch endpoint. However, it does apply when using the **Log in with Elastic Cloud** option.
**My team uses a generic account or distribution/mailing list and shares the password to access Elastic Cloud. How will my team be able to log in and access our Elastic Cloud organization after the MFA enforcement?**
The only secure and recommended approach is to use one Elastic account for each Elastic Cloud user. You can grant your team members access to that account’s Elastic Cloud organization by inviting and making them organization members. This may involve creating additional Elastic user accounts for each team member, depending on their organization access and ownership needs, because Elastic does not support multi-organization membership. When each team member has their own account to access your Elastic Cloud organization, they will be able to set up their own MFA method.
**After I set up an MFA method, will I need to answer an MFA challenge every time I authenticate through Elastic Cloud?**
For now, you will need to answer an MFA challenge on every login, but we are working on adding a **Trust this device** option, which will "silence" the MFA challenge for one month per user session.
**Can I use multiple email addresses for MFA?**
No, only one email address can be used for MFA verification. In alignment with security best practices, Elastic Cloud is designed to use only one designated email address for MFA purposes. This email is used to send your one-time verification codes during login. If you need to update your MFA email address, review [Update your email address](https://www.elastic.co/docs/cloud-account/update-your-email-address) for more information.