﻿---
title: Manage your Cloud account and preferences
description: Manage your Elastic Cloud account settings, including email, password, authentication methods, and personal preferences. Configure your user profile and customize your interface.
url: https://www.elastic.co/docs/cloud-account
products:
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Manage your Cloud account and preferences
Your Elastic Cloud account allows you to manage your personal settings, including your email address, password, and authentication methods. You can perform the following tasks at any time from your user profile:
- [Update your email address](https://www.elastic.co/docs/cloud-account/update-your-email-address)
- [Add an additional login method](https://www.elastic.co/docs/cloud-account/add-a-login-method): Choose from password-based login, Google sign-in, and Microsoft sign-in.

If you use password-based login, then you can perform the following additional tasks:
- [Change your password](https://www.elastic.co/docs/cloud-account/change-your-password)
- [Configure multifactor authentication](https://www.elastic.co/docs/cloud-account/multifactor-authentication)

Additionally, you can manage your organization membership, including joining or leaving an organization. Refer to [Join or leave an organization](https://www.elastic.co/docs/cloud-account/join-or-leave-an-organization) for more information.
Some options also let you set personal preferences and customize the interface, such as [using dark mode](https://www.elastic.co/docs/cloud-account/dark-mode) in your projects and deployments.
<tip>
  This section focuses on the actions you can take as an individual user to manage your own account. It does not cover organization-wide settings, such as managing user permissions or configuring organization-level access controls, which are handled by the organization administrators.For information on organization and access management, refer to:
  - [Manage your Cloud organization](https://www.elastic.co/docs/deploy-manage/cloud-organization)
  - [Manage user roles and permissions](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles)
</tip>